const { DataTypes } = require("sequelize");
const sequelize = require("../../config/database"); // Update with your database connection file path

const Category = sequelize.define('Category', {
    category_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      index: true
    },
    category_name: {
      type: DataTypes.STRING,
      allowNull: false,
      index: true
    },
    url: {
      type: DataTypes.STRING,
      allowNull: true,
      index: true
    }
  }, {
    timestamps: false,
    tableName: 'category'
  });

  module.exports = Category ;